<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/POG_5.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Trader.xsd" xmlns:ns5="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/POG_5A.xsd" xmlns:ns6="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/POG_5C.xsd" xmlns:ns7="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/POG_5D.xsd" version="1.0"><xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/><xsl:output encoding="iso-8859-1" method="html"/><xsl:template match="/"><xsl:apply-templates select="*"/></xsl:template><!-- POCZATEK ALL --><!-- STYL ARKUSZA --><xsl:template match="*" mode="styl1"><style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style><style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style><style type="text/css">a{color:#3366FF;font-weight:bold;}</style><style type="text/css">h3{padding:3px;cursor:help;}</style><style type="text/css">h4,h5,.copyr{text-align:center;}</style><style type="text/css">caption{font-weight:bold;}</style><style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style><style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">#cont{display:none}</style><style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style><style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style><style type="text/css">.nag2{font-size: 20px}</style><style type="text/css">.cz10 {font-size: 10px}</style><style type="text/css">.cz12 {	font-size: 12px}</style><style type="text/css">.cz18 {font-size: 18px}</style><style type="text/css">.cz16 {font-size: 16px}</style><style type="text/css">.cz14 {font-size: 14px}</style></xsl:template><!-- SZABLON STOPKI --><xsl:template match="*" mode="stopka"><xsl:text>POG5</xsl:text></xsl:template><xsl:template match="*"><!-- ZASTOSOWANIE STYLU --><xsl:apply-templates mode="styl1" select="*"/><!-- DEKLARACJE AKCYZOWE --><xsl:apply-templates mode="dekl_AKCWW" select="."/></xsl:template><!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --><xsl:template match="*" mode="dekl_AKCWW"><xsl:for-each select=" ns1:Header"><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="."/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT. UWAGI --><xsl:apply-templates mode="Uwaga" select="."/><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:apply-templates mode="PodstawaPrawna" select="."/><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:apply-templates mode="MiejsceDekl" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika" select="."/><!-- SZABLON DOT. ADRESU PODATNIKA --><xsl:apply-templates mode="Adres" select="."/><!-- SZABLON DOT. ILOSCI ZALACZNIKOW --><xsl:apply-templates mode="IleZalGry" select="."/><!-- SZABLON DOT. PODATKU OD GRY --><xsl:apply-templates mode="ZestawieniePodatkuGry" select="."/><!-- SZABLON DOT. ROZLICZENIA PODATKU OD GIER --><xsl:apply-templates mode="RozliczeniePodatkuGry" select="."/><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:apply-templates mode="OswPodatnika" select="."/><!-- SZABLON DOT. ADNOTACJI--><xsl:apply-templates mode="Adnotacje" select="."/><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:apply-templates mode="ObjasnieniaAkc" select="."/><!--ZALACZNIKI POG5A --><xsl:for-each select=".//ns5:POG5A"><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="./*"/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT. UWAGI --><xsl:apply-templates mode="Uwaga" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika_Zal_Gry" select="."/><!-- SZABLON DOT. DANYCH O ZEZWOLENIU --><xsl:apply-templates mode="Zezwolenie" select="."/><!-- SZABLON DOT. DANYCH O MONOPOLU --><xsl:apply-templates mode="Monopol" select="."/><!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --><xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/></xsl:for-each><!--ZALACZNIKI POG5C --><xsl:for-each select=".//ns6:POG5C"><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="./*"/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT. UWAGI --><xsl:apply-templates mode="Uwaga" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika_Zal_Gry" select="."/><!-- SZABLON DOT. DANYCH O ZEZWOLENIU --><xsl:apply-templates mode="Zezwolenie" select="."/><!-- SZABLON DOT. DANYCH O MONOPOLU --><xsl:apply-templates mode="Monopol" select="."/><!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --><xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/></xsl:for-each><!--ZALACZNIKI POG5D --><xsl:for-each select=".//ns7:POG5D"><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="./*"/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT. UWAGI --><xsl:apply-templates mode="Uwaga" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika_Zal_Gry" select="."/><!-- SZABLON DOT. DANYCH O ZEZWOLENIU --><xsl:apply-templates mode="Zezwolenie" select="."/><!-- SZABLON DOT. DANYCH O MONOPOLU --><xsl:apply-templates mode="Monopol" select="."/><!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --><xsl:apply-templates mode="ObliczeniePodatkuGry" select="."/></xsl:for-each></xsl:for-each></xsl:template><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:template match="*" mode="Ident"><table border="1" width="955"><tr align="left" valign="top"><td align="left" height="45" valign="middle" width="586"><span class="cz12"><b>1. Identyfikator podatkowy NIP/numer PESEL (niepotrzebne skreslic) podatnika </b></span></td><td align="center" valign="middle" width="353"><span class="nag2"><b><xsl:value-of select="@identifier"/></b></span></td></tr><tr align="left" valign="top"><td align="left" height="45" valign="top"><b>Numer wlasny:</b><span class="cz18"><xsl:value-of select="@selfRef"/></span><br/><b>Data wypelnienia deklaracji:</b><span class="cz18"><xsl:value-of select="substring(ns1:Statement/@declarationDate,1,10)"/></span></td><td align="center" valign="bottom"><xsl:if test="@refNumber">Nr referencyjny nadany przez System eZefir:<br/><xsl:value-of select="@refNumber"/></xsl:if></td></tr></table></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl"><xsl:if test="ns1:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1"><xsl:text>POG5</xsl:text></span></td></tr><tr><td height="61" width="154"/><td width="537"><div align="center"><span class="nag1">DEKLARACJA DLA PODATKU OD GIER</span><br/><span class="nag1"/></div></td><td width="243"/></tr></table></xsl:if><xsl:if test="ns5:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">POG-5/A</span></td></tr><tr><td height="61" width="154"/><td width="537"><xsl:attribute name="bgcolor">#CCCCCC</xsl:attribute><div align="center"><span class="nag1">ZALACZNIK DO DEKLARACJI POG-5<br/>DLA PODATKU OD GIER</span><br/><span class="nag1"> za </span></div></td><td width="243"/></tr></table></xsl:if><xsl:if test="ns6:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">POG-5/C</span></td></tr><tr><td height="61" width="154"/><td width="537"><xsl:attribute name="bgcolor">#CCCCCC</xsl:attribute><div align="center"><span class="nag1">ZALACZNIK DO DEKLARACJI POG-5<br/>DLA PODATKU OD GIER</span><br/><span class="nag1"> za </span></div></td><td width="243"/></tr></table></xsl:if><xsl:if test="ns7:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">POG-5/D</span></td></tr><tr><td height="61" width="154"/><td width="537"><xsl:attribute name="bgcolor">#CCCCCC</xsl:attribute><div align="center"><span class="nag1">ZALACZNIK DO DEKLARACJI POG-5<br/>DLA PODATKU OD GIER</span><br/><span class="nag1"> za </span></div></td><td width="243"/></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:template match="*" mode="rok_mc"><xsl:if test="ns1:*"><table border="1" width="955"><tr><td height="49" width="247"/><td align="left" valign="top" width="135"><b>4. Miesiac/Kwartal</b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,6,7)"/> - <xsl:value-of select="substring(@periodTo,6,7)"/></div></td><td align="left" valign="top" width="131"><b>5. Rok </b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,1,4)"/></div></td><td width="206"/><td align="left" valign="top" width="206"><br/><div align="center" class="cz18"/></td></tr></table></xsl:if><xsl:if test="ns5:* | ns6:* | ns7:*"><table border="1" width="955"><tr><td height="49" width="247"/><td align="left" valign="top" width="135"><b>5. Miesiac</b><br/><div align="center" class="cz18"><xsl:value-of select="substring(.//@period,6,7)"/></div></td><td align="left" valign="top" width="131"><b>6. Rok </b><br/><div align="center" class="cz18"><xsl:value-of select="substring(.//@period,1,4)"/></div></td><td width="206"/><td align="left" valign="top" width="206"><b>4. Numer zalacznika 1)</b><br/><div align="center" class="cz18"><xsl:value-of select=".//@formNo"/></div></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. UWAGI --><xsl:template match="*" mode="Uwaga"><xsl:if test="ns1:*"><table width="955"><tr><td><span class="cz12">Formularz przeznaczony jest dla podatnikOw podatku od gier:<br/><li>prowadzacych kasyna gry, salony gier na automatach oraz urzadzajacych loterie pieniezne, zaklady wzajemne, a takze 	podatnikOw podatku od gier prowadzacych gry telebingo i audiotekstowe,</li><li>urzadzajacych gry liczbowe,</li><li>urzadzajacych gre bingo fantowe i loterie fantowa,</li></span></td></tr></table></xsl:if><xsl:if test="ns5:*"><table width="955"><tr><td><span class="cz12">Formularz przeznaczony jest dla podatnikOw podatku od gier	prowadzacych kasyna gry, salony gry bingo pieniezne oraz urzadzajacych zaklady wzjemne, loterie pieniezne, gre telebingo i loterie audiotekstowe.		</span></td></tr></table></xsl:if><xsl:if test="ns6:*"><table width="955"><tr><td><span class="cz12">Formularz przeznaczony jest dla podatnikOw podatku od gier urzadzajacych gry liczbowe.		</span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:template match="*" mode="PodstawaPrawna"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td align="left" valign="top" width="115">Podstawa prawna: </td><td align="left" valign="top" width="824">Art.75 ust.6 ustawy z dnia 19 listopada 2009 r. o grach hazardowych (Dz.U. Nr201, poz.1540), zwanej dalej 'ustawa'.</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Skladajacy:</td><td align="left" valign="top">Podatnicy podatku od gier, zwani dalej 'podatnikami' z wylaczeniem podatnikow prowadzacych salony gry bingo pieniezne.</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Termin skladania:</td><td align="left" valign="top">W terminie do 10 dnia miesiaca nastepujacego po miesiacu, ktorego dotyczy rozliczenie (art.42a ust.2 i 4 ustawy).</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Miejsce skladania: </td><td align="left" valign="top">Naczelnik urzedu celnego wlasciwy zgodnie z art.42b ust.1 pkt 1-3 ustawy, zwany dalej 'organem'. </td></tr></table></xsl:template><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:template match="*" mode="MiejsceDekl"><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><span class="nag1">A. MIEJSCE I CEL SKLADANIA DEKLARACJI</span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="4" width="46"/><td colspan="2"><b>6. Organ, do ktorego skladana jest deklaracja</b><br/><br/><span class="cz18"><xsl:variable name="customsOffice" select="@customsOffice"/><xsl:if test="$customsOffice='371000'"><xsl:text>Urzad Celny w Olsztynie</xsl:text></xsl:if><xsl:if test="$customsOffice='394000'"><xsl:text>Urzad Celny w Kaliszu</xsl:text></xsl:if><xsl:if test="$customsOffice='362000'"><xsl:text>Urzad Celny II w Lodzi</xsl:text></xsl:if><xsl:if test="$customsOffice='392000'"><xsl:text>Urzad Celny w Pile</xsl:text></xsl:if><xsl:if test="$customsOffice='420000'"><xsl:text>Izba Celna w Szczecinie</xsl:text></xsl:if><xsl:if test="$customsOffice='311000'"><xsl:text>Urzad Celny w Bialymstoku</xsl:text></xsl:if><xsl:if test="$customsOffice='393000'"><xsl:text>Urzad Celny w Lesznie</xsl:text></xsl:if><xsl:if test="$customsOffice='432000'"><xsl:text>Urzad Celny w Toruniu</xsl:text></xsl:if><xsl:if test="$customsOffice='332000'"><xsl:text>Urzad Celny w Rybniku</xsl:text></xsl:if><xsl:if test="$customsOffice='000001'"><xsl:text>wszyscy</xsl:text></xsl:if><xsl:if test="$customsOffice='451000'"><xsl:text>Urzad Celny we Wroclawiu</xsl:text></xsl:if><xsl:if test="$customsOffice='370000'"><xsl:text>Izba Celna w Olsztynie</xsl:text></xsl:if><xsl:if test="$customsOffice='320000'"><xsl:text>Izba Celna w Gdyni</xsl:text></xsl:if><xsl:if test="$customsOffice='313000'"><xsl:text>Urzad Celny w Suwalkach</xsl:text></xsl:if><xsl:if test="$customsOffice='444000'"><xsl:text>Urzad Celny w Radomiu</xsl:text></xsl:if><xsl:if test="$customsOffice='321000'"><xsl:text>Urzad Celny w Gdyni</xsl:text></xsl:if><xsl:if test="$customsOffice='323000'"><xsl:text>Urzad Celny w Slupsku</xsl:text></xsl:if><xsl:if test="$customsOffice='380000'"><xsl:text>Izba Celna w Opolu</xsl:text></xsl:if><xsl:if test="$customsOffice='441000'"><xsl:text>Urzad Celny I w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='340000'"><xsl:text>Izba Celna w Kielcach</xsl:text></xsl:if><xsl:if test="$customsOffice='452000'"><xsl:text>Urzad Celny w Legnicy</xsl:text></xsl:if><xsl:if test="$customsOffice='300000'"><xsl:text>Izba Celna w Bialej Podlaskiej</xsl:text></xsl:if><xsl:if test="$customsOffice='341000'"><xsl:text>Urzad Celny w Kielcach</xsl:text></xsl:if><xsl:if test="$customsOffice='431000'"><xsl:text>Urzad Celny w Bydgoszczy</xsl:text></xsl:if><xsl:if test="$customsOffice='400000'"><xsl:text>Izba Celna w Przemyslu</xsl:text></xsl:if><xsl:if test="$customsOffice='446000'"><xsl:text>Urzad Celny w Siedlcach</xsl:text></xsl:if><xsl:if test="$customsOffice='322000'"><xsl:text>Urzad Celny w Gdansku</xsl:text></xsl:if><xsl:if test="$customsOffice='301000'"><xsl:text>Urzad Celny w Bialej Podlaskiej</xsl:text></xsl:if><xsl:if test="$customsOffice='454000'"><xsl:text>Urzad Celny w Walbrzychu</xsl:text></xsl:if><xsl:if test="$customsOffice='404000'"><xsl:text>Urzad Celny w Krosnie</xsl:text></xsl:if><xsl:if test="$customsOffice='000000'"><xsl:text>Ministerstwo Finans�w</xsl:text></xsl:if><xsl:if test="$customsOffice='331000'"><xsl:text>Urzad Celny w Katowicach</xsl:text></xsl:if><xsl:if test="$customsOffice='447000'"><xsl:text>Urzad Celny w Ciechanowie</xsl:text></xsl:if><xsl:if test="$customsOffice='390000'"><xsl:text>Izba Celna w Poznaniu</xsl:text></xsl:if><xsl:if test="$customsOffice='391000'"><xsl:text>Urzad Celny w Poznaniu</xsl:text></xsl:if><xsl:if test="$customsOffice='443000'"><xsl:text>Urzad Celny III "Port Lotniczy" w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='372000'"><xsl:text>Urzad Celny w Elblagu</xsl:text></xsl:if><xsl:if test="$customsOffice='410000'"><xsl:text>Izba Celna w Rzepinie</xsl:text></xsl:if><xsl:if test="$customsOffice='350000'"><xsl:text>Izba Celna w Krakowie</xsl:text></xsl:if><xsl:if test="$customsOffice='411000'"><xsl:text>Urzad Celny w Zielonej G�rze</xsl:text></xsl:if><xsl:if test="$customsOffice='335000'"><xsl:text>Urzad Celny w Bielsku-Bialej</xsl:text></xsl:if><xsl:if test="$customsOffice='351000'"><xsl:text>Urzad Celny w Krakowie</xsl:text></xsl:if><xsl:if test="$customsOffice='361000'"><xsl:text>Urzad Celny I w Lodzi</xsl:text></xsl:if><xsl:if test="$customsOffice='333000'"><xsl:text>Urzad Celny w Czestochowie</xsl:text></xsl:if><xsl:if test="$customsOffice='360000'"><xsl:text>Izba Celna w Lodzi</xsl:text></xsl:if><xsl:if test="$customsOffice='330000'"><xsl:text>Izba Celna w Katowicach</xsl:text></xsl:if><xsl:if test="$customsOffice='421000'"><xsl:text>Urzad Celny w Szczecinie</xsl:text></xsl:if><xsl:if test="$customsOffice='312000'"><xsl:text>Urzad Celny w Lomzy</xsl:text></xsl:if><xsl:if test="$customsOffice='401000'"><xsl:text>Urzad Celny w Przemyslu</xsl:text></xsl:if><xsl:if test="$customsOffice='353000'"><xsl:text>Urzad Celny w Nowym Saczu</xsl:text></xsl:if><xsl:if test="$customsOffice='402000'"><xsl:text>Urzad Celny w Rzeszowie</xsl:text></xsl:if><xsl:if test="$customsOffice='445000'"><xsl:text>Urzad Celny w Pruszkowie</xsl:text></xsl:if><xsl:if test="$customsOffice='440000'"><xsl:text>Izba Celna w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='352000'"><xsl:text>Urzad Celny w Nowym Targu</xsl:text></xsl:if><xsl:if test="$customsOffice='422000'"><xsl:text>Urzad Celny w Koszalinie</xsl:text></xsl:if><xsl:if test="$customsOffice='363000'"><xsl:text>Urzad Celny w Piotrkowie Trybunalskim</xsl:text></xsl:if><xsl:if test="$customsOffice='412000'"><xsl:text>Urzad Celny w Gorzowie Wielkopolskim</xsl:text></xsl:if><xsl:if test="$customsOffice='430000'"><xsl:text>Izba Celna w Toruniu</xsl:text></xsl:if><xsl:if test="$customsOffice='442000'"><xsl:text>Urzad Celny II w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='381000'"><xsl:text>Urzad Celny w Opolu</xsl:text></xsl:if><xsl:if test="$customsOffice='302000'"><xsl:text>Urzad Celny w Lublinie</xsl:text></xsl:if><xsl:if test="$customsOffice='303000'"><xsl:text>Urzad Celny w Zamosciu</xsl:text></xsl:if><xsl:if test="$customsOffice='450000'"><xsl:text>Izba Celna we Wroclawiu</xsl:text></xsl:if></span></td></tr><tr><td class="style3" colspan="2"><b>7. Numer identyfikacyjny organu, do ktorego skladana jest deklaracja<sup>1)</sup></b><br/><br/><span class="cz18"><xsl:value-of select="@customsOffice"/></span></td></tr><tr><td class="style3" colspan="2"><b>8. Cel zlozenia formularza</b>(zaznaczyc wlasciwy kwadrat):	</td></tr><tr><td align="left" valign="top" width="422">1. zlozenie deklaracji<br/><xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"><br/><span class="cz18"><b>X - </b><xsl:value-of select="@submissionAim"/></span></xsl:if></td><td align="left" valign="top" width="471">2. korekta deklaracji<sup>2)</sup><br/><xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"><br/><span class="cz18"><b>X - </b><xsl:value-of select="@submissionAim"/></span><br/><xsl:value-of select="@justification"/></xsl:if></td></tr></table></xsl:template><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:template match="*" mode="DanePodatnika"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">B. DANE PODATNIKA</span><br/>*- dotyczy podmiotOwniebedacych osobami fizycznymi     **- dotyczy podmiotOw bedacych osobami fizycznymi </td></tr><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag2">B.1. DANE IDENTYFIKACYJNE</span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="4" width="38"/><td align="left" colspan="2" valign="top"><b>9. Rodzaj podatnika (zaznaczyc wlasciwy kwadrat): </b></td></tr><tr><td align="left" valign="top" width="425">1. podatnik niebedacy osoba fizyczna<xsl:for-each select=".//ns4:Corporate"><b><span class="cz14">X</span></b></xsl:for-each></td><td align="left" valign="top" width="470">2. osoba fizyczna<xsl:for-each select=".//ns4:PrivatePerson"><b><span class="cz14">X</span></b></xsl:for-each></td></tr><tr><td align="left" colspan="2" valign="top"><b>10. Nazwa pelna */ Nazwisko, pierwsze imie, data urodzenia **</b><br/><br/><xsl:for-each select=".//ns4:Corporate"><span class="cz18"><xsl:value-of select=".//@fullName"/></span></xsl:for-each><xsl:for-each select=".//ns4:PrivatePerson"><br/><br/><span class="cz18"><xsl:value-of select=".//@firstName"/></span><span class="cz18"><xsl:value-of select=".//@surname"/></span><span class="cz18"><xsl:value-of select=".//@dateOfBirth"/></span></xsl:for-each></td></tr><tr><td align="left" valign="top"><b>11. Numer identyfikacyjny REGON* </b><br/><br/><span class="cz18"><xsl:value-of select=".//@REGON"/></span></td><td align="left" valign="top"><b>12. Numer identyfikacyjny PESEL** </b><br/><br/><span class="cz18"><xsl:value-of select=".//@PESEL"/></span></td></tr></table></xsl:template><!-- SZABLON DOT. ADRESU PODATNIKA --><xsl:template match="*" mode="Adres"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">B.2. ADRES SIEDZIBY** / ADRES ZAMIESZKANIA *** </span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td width="269"><b>10. Kraj </b><br/><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>11. Wojewodztwo</b><br/><br/><span class="cz18"><xsl:value-of select=".//@province"/></span></td><td colspan="2"><b>12. Powiat</b><br/><br/><span class="cz18"><xsl:value-of select=".//@district"/></span></td></tr><tr align="left" valign="top"><td><b>13. Gmina </b><br/><br/><span class="cz18"><xsl:value-of select=".//@commune"/></span></td><td colspan="2"><b>14. Ulica</b><br/><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>15. Nr domu</b><br/><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>16. Nr lokalu</b><br/><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>17. Miejscowosc</b><br/><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td width="130"><b>18. Kod pocztowy</b><br/><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td width="181"><b>19. Poczta</b><br/><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td><td colspan="2"><b>Adres e-mail i nr telefonu</b><br/><span class="cz18"><xsl:value-of select=".//@email"/>;</span><br/><span class="cz18"><xsl:value-of select="@phone"/></span></td></tr></table><table width="955"><tr><td><sup>1)</sup>numer PESEL nalezy podac w przypadku podatnikow bedacych osobami fizycznymi objetymi rejestrem PESEL nieprowadzacych dzialalnosci gospodarczej lub niebedacych zarejestrowanymi podatnikami podatku od towarow i uslug </td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1"><xsl:apply-templates mode="stopka" select="../.."/></span><sub style="cz9">(1)</sub><b style="nag1">/1</b></td></tr></table></xsl:template><!-- SZABLON DOT. ILOSCI ZALACZNIKOW --><xsl:template match="*" mode="IleZalGry"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">C. INFORMACJE O ZALACZNIKACH</span><br/>W poz.21-24 nalezy podac liczbe dolaczonych zalacznikow.</td></tr><tr><td bgcolor="#CCCCCC" rowspan="2" width="36"/><td align="center" bgcolor="#CCCCCC" valign="middle" width="236"><span class="cz18"><b>POG-5/A</b></span></td><td align="center" bgcolor="#CCCCCC" valign="middle" width="304"><span class="cz18"><b>POG-5/C</b></span></td><td align="center" bgcolor="#CCCCCC" valign="middle" width="351"><span class="cz18"><b>POG-5/D</b></span></td></tr><tr><td align="left" valign="top"><b>23.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="count(.//ns5:POG5A)"/></div></td><td align="left" valign="top"><b>24.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="count(.//ns6:POG5C)"/></div></td><td align="left" valign="top"><b>25.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="count(.//ns7:POG5D)"/></div></td></tr></table><table width="955"><tr><td><sup>1)</sup>Wykaz numerOw identyfikacyjnych urzedow celnych jest dostepny na stronach internetowych Ministerstwa Finansow i Izb Celnych oraz 	bezposrednio w siedzibach tych organOw.<br/><sup>2)</sup>Zgodnie z art.81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz.U. z 2005 r. Nr 8, poz.60, z pozn. zm.), podatnik moze 	skorygowac zlozona deklaracje poprzez zloeenie deklaracji korygujacej wraz z dolaczonym pisemnym uzasadnieniem przyczyn korekty.</td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1"><xsl:apply-templates mode="stopka" select="../.."/></span><sub style="cz9">(1)</sub><b style="nag1">/1</b></td></tr></table></xsl:template><!-- SZABLON DOT. PODATKU OD GRY --><xsl:template match="*" mode="ZestawieniePodatkuGry"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">D. ZESTAWIENIE PODATKU</span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="6" width="45"/><td align="center" bgcolor="#CCCCCC" valign="top" width="497"><span class="cz14"><b>Symbol zalacznika </b></span></td><td align="center" bgcolor="#CCCCCC" valign="top" width="391"><span class="cz14"><b>Zbiorcze zestawienie podatku</b></span></td></tr><tr><td align="left" valign="top"><b>POG-4/A</b><br/><br/>Nalezy wpisac sume kwot podatku z poz.42 poszczegolnych zalacznikow</td><td align="left" valign="top"><b>26.</b><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@amountPog5a"/></div></td></tr><tr><td align="left" valign="top"><b>POG-4/C</b><br/><br/>Nalezy wpisac sume kwot podatku z poz.13 poszczegolnych zalacznikow</td><td align="left" valign="top"><b>27.</b><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@amountPog5c"/></div></td></tr><tr><td align="left" valign="top"><b>POG-4/D</b><br/><br/>		Nalezy wpisac sume kwot podatku z poz.19 poszczegolnych zalacznikow</td><td align="left" valign="top"><b>28.</b><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@amountPog5d"/></div></td></tr><tr><td align="left" valign="top"><b>Razem </b><br/><br/>Suma kwot z poz. od 25 do 28.</td><td align="left" bordercolor="#000000" valign="top"><b>29.</b><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@amountPog5a + .//@amountPog5c + .//@amountPog5d"/></div></td></tr></table></xsl:template><!-- SZABLON DOT. ROZLICZENIA PODATKU OD GIER --><xsl:template match="*" mode="RozliczeniePodatkuGry"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1"><b>D. ROZLICZENIE PODATKU</b></span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="4" width="40"/><td width="596"><b>Nadplata wplat dzinnych z ostatnio zlozonej deklaracji</b><br/><br/>Kwota z poz.33 deklaracji zlozonej za poprzedni okres.	</td><td align="left" valign="top" width="297"><b>30.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="//@excessContributSettlementOfPrevDecl"/></div></td></tr><tr><td><b>Wplaty dzienne podatku od gier liczbowych (tylko dla zalacznika POG-5/C) za okres, ktorego deklaracja dotyczy</b><br/><br/>Nalezy wpisac kwote z poz.14 zalacznika POG-5/C</td><td align="left" valign="top"><b>31.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="//@amountOfPaymentsDaily"/></div></td></tr><tr><td><b>Kwota do zaplaty*)</b><br/><br/>Od kwoty z poz.29 nalezy odjac sume kwot z poz.30 i 31. Jezeli roznica jest liczba ujemna, nalezy wpisac 0.</td><td align="left" valign="top"><b>32.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="//@toPay"/></div></td></tr><tr><td><b>Nadwyzka wplat dziennych do rozliczania w nastepnym okresie rozliczeniowym</b><br/><br/>Od sumy kwoty z poz.30 i 31 nalezy odjac kwote z poz.29. Jezeli roznica jest liczba ujemna, nalezy wpisac 0.</td><td align="left" valign="top"><b>33.</b><div align="right" class="cz18" valign="top"><xsl:value-of select="//@excessContributSettlement"/></div></td></tr></table></xsl:template><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:template match="*" mode="OswPodatnika"><xsl:if test="ns1:* | ns3:*"><table border="1" height="210" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><b><span class="nag1">D. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ PODATNIKA</span></b><br/>Oswiadczam, ze sa mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialnosci za podanie danych niezgodnych z rzeczywistoscia.</td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td height="37" width="402"><b>108. Imie </b><br/><br/><span class="cz18"><xsl:value-of select="//@repFirstName"/></span></td><td width="491"><b> 109. Nazwisko </b><br/><br/><span class="cz18"><xsl:value-of select="//@repSurname "/></span></td></tr><tr align="left" valign="top"><td height="39"><b>110. Data wypelnienia deklaracji (dzien-miesiac-rok) </b><br/><br/><br/><span class="cz18"><xsl:value-of select="substring(//@declarationDate,1,10)"/></span></td><td><b> 111. Podpis (i pieczatka) podatnika lub osoby reprezentujacej podatnika </b></td></tr><tr align="left" valign="top"><td colspan="2" height="70"><b>112. Numer telefonu i adres e-mail podatnika lub osoby reprezentujacej podatnika </b><br/><br/><span class="cz18"><xsl:value-of select="//@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADNOTACJI--><xsl:template match="*" mode="Adnotacje"><xsl:if test="ns1:*"><table border="1" height="167" width="955"><tr bgcolor="#CCCCCC"><td class="nag1" colspan="3" height="36"> E. ADNOTACJE URZEDU CELNEGO </td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td rowspan="2" width="40"/><td colspan="2" height="72"><b>113. Uwagi urzedu celnego <br/><br/><br/><br/><br/><br/><br/></b></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td height="49" width="472"><b>114. Identyfikator przyjmujacego formularz <br/><br/><br/></b><p/></td><td width="421"><b> 115. Podpis przyjmujacego formularz </b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:template match="*" mode="ObjasnieniaAkc"><xsl:if test="ns1:*"><table width="955"><tr><td><p align="center">***)<b> Pouczenie: </b></p><p>Za podanie nieprawdy lub zatajenie prawdy i przez to narazenie podatku na uszczuplenie grozi odpowiedzialnosc przewidziana w kodeksie karnym skarbowym.</p><p>W przypadku niewplacenia w obowiazujacym terminie kwoty z poz. 107 lub wplacenia jej w niepelnej wysokosci, niniejsza deklaracja stanowi podstawe do wystawienia tytulu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966. o postepowaniu egzekucyjnym w administracji (Dz.U. z 2012 r. poz. 1015 z pozn. zm.). </p><p align="center"><b>Objasnienia:</b><b/></p><p>Podstawy opodatkowania (wyrazone kwotowo) i kwoty podatkow zaokragla sie do pelnych zlotych w ten sposob, ze koncowki kwot wynoszace mniej niz 50 groszy pomija sie, a koncowki kwot wynoszace 50 i wiecej groszy podwyzsza sie do pelnych zlotych - zgodnie z art. 63 � 1 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz.U. z 2012 r. poz. 749 z pozn. zm.).</p></td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1"><xsl:apply-templates mode="stopka" select="../.."/></span><sub style="cz9">(3)</sub><b style="nag1">/2</b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. DANYCH PODATNIKA W ZALACZNIKACH--><xsl:template match="*" mode="DanePodatnika_Zal_Gry"><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC"><td colspan="2"><span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA</span></td></tr><tr align="left"><td bgcolor="#CCCCCC" rowspan="2" width="46"/><td align="left" valign="top" width="893"><b>7. Nazwa pelna</b><br/><span class="cz18"><xsl:value-of select=".//@fullName"/></span><span class="cz18"><xsl:value-of select=".//@firstName"/></span><span class="cz18"><xsl:value-of select=".//@surname"/></span><span class="cz18"><xsl:value-of select=".//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select=".//@PESEL"/></span></td></tr><tr><td align="left" class="style3" valign="top"><b>8. Numer identyfikacyjny REGON</b><br/><span class="cz18"><xsl:value-of select="//@Regon"/></span></td></tr></table></xsl:template><!-- SZABLON DOT. DANYCH O ZEZWOLENIU --><xsl:template match="*" mode="Zezwolenie"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">B. DANE O ZEZWOLENIU </span>W przypadku gdy w ramach wlasciwosci miejscowej jednego naczelnika urzedu celnego podatnik posiada<br/>wiecej niz jedno zezwolenie, podatnik powinien zlozyc tyle zalacznikOw, ile zezwolen posiada.</td></tr><tr><td bgcolor="#CCCCCC" rowspan="2" width="40"/><td align="left" valign="top" width="549"><b>10. Numer zezwolenia wydanego na podstawie art.24 ust.1 ustawy</b><br/><br/><div align="left" class="cz18" valign="top"><xsl:value-of select="//@numberOfConcession"/></div></td><td align="left" valign="top" width="344"><b>11. Data wydania zezwolenia (dzien-miesiac-rok)</b><br/><br/><div align="center" class="cz18" valign="top"><xsl:value-of select="substring(//@creationDate,1,10)"/></div></td></tr><tr><td align="left" colspan="2" valign="top"><b>12. Organ wydajacy zezwolenie</b><br/><div align="left" class="cz18" valign="top"><xsl:variable name="customsOffice" select="//@customsOffice"/><xsl:if test="$customsOffice='371000'"><xsl:text>Urzad Celny w Olsztynie</xsl:text></xsl:if><xsl:if test="$customsOffice='394000'"><xsl:text>Urzad Celny w Kaliszu</xsl:text></xsl:if><xsl:if test="$customsOffice='362000'"><xsl:text>Urzad Celny II w Lodzi</xsl:text></xsl:if><xsl:if test="$customsOffice='392000'"><xsl:text>Urzad Celny w Pile</xsl:text></xsl:if><xsl:if test="$customsOffice='420000'"><xsl:text>Izba Celna w Szczecinie</xsl:text></xsl:if><xsl:if test="$customsOffice='311000'"><xsl:text>Urzad Celny w Bialymstoku</xsl:text></xsl:if><xsl:if test="$customsOffice='393000'"><xsl:text>Urzad Celny w Lesznie</xsl:text></xsl:if><xsl:if test="$customsOffice='432000'"><xsl:text>Urzad Celny w Toruniu</xsl:text></xsl:if><xsl:if test="$customsOffice='332000'"><xsl:text>Urzad Celny w Rybniku</xsl:text></xsl:if><xsl:if test="$customsOffice='000001'"><xsl:text>wszyscy</xsl:text></xsl:if><xsl:if test="$customsOffice='451000'"><xsl:text>Urzad Celny we Wroclawiu</xsl:text></xsl:if><xsl:if test="$customsOffice='370000'"><xsl:text>Izba Celna w Olsztynie</xsl:text></xsl:if><xsl:if test="$customsOffice='320000'"><xsl:text>Izba Celna w Gdyni</xsl:text></xsl:if><xsl:if test="$customsOffice='313000'"><xsl:text>Urzad Celny w Suwalkach</xsl:text></xsl:if><xsl:if test="$customsOffice='444000'"><xsl:text>Urzad Celny w Radomiu</xsl:text></xsl:if><xsl:if test="$customsOffice='321000'"><xsl:text>Urzad Celny w Gdyni</xsl:text></xsl:if><xsl:if test="$customsOffice='323000'"><xsl:text>Urzad Celny w Slupsku</xsl:text></xsl:if><xsl:if test="$customsOffice='380000'"><xsl:text>Izba Celna w Opolu</xsl:text></xsl:if><xsl:if test="$customsOffice='441000'"><xsl:text>Urzad Celny I w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='340000'"><xsl:text>Izba Celna w Kielcach</xsl:text></xsl:if><xsl:if test="$customsOffice='452000'"><xsl:text>Urzad Celny w Legnicy</xsl:text></xsl:if><xsl:if test="$customsOffice='300000'"><xsl:text>Izba Celna w Bialej Podlaskiej</xsl:text></xsl:if><xsl:if test="$customsOffice='341000'"><xsl:text>Urzad Celny w Kielcach</xsl:text></xsl:if><xsl:if test="$customsOffice='431000'"><xsl:text>Urzad Celny w Bydgoszczy</xsl:text></xsl:if><xsl:if test="$customsOffice='400000'"><xsl:text>Izba Celna w Przemyslu</xsl:text></xsl:if><xsl:if test="$customsOffice='446000'"><xsl:text>Urzad Celny w Siedlcach</xsl:text></xsl:if><xsl:if test="$customsOffice='322000'"><xsl:text>Urzad Celny w Gdansku</xsl:text></xsl:if><xsl:if test="$customsOffice='301000'"><xsl:text>Urzad Celny w Bialej Podlaskiej</xsl:text></xsl:if><xsl:if test="$customsOffice='454000'"><xsl:text>Urzad Celny w Walbrzychu</xsl:text></xsl:if><xsl:if test="$customsOffice='404000'"><xsl:text>Urzad Celny w Krosnie</xsl:text></xsl:if><xsl:if test="$customsOffice='000000'"><xsl:text>Ministerstwo Finans�w</xsl:text></xsl:if><xsl:if test="$customsOffice='331000'"><xsl:text>Urzad Celny w Katowicach</xsl:text></xsl:if><xsl:if test="$customsOffice='447000'"><xsl:text>Urzad Celny w Ciechanowie</xsl:text></xsl:if><xsl:if test="$customsOffice='390000'"><xsl:text>Izba Celna w Poznaniu</xsl:text></xsl:if><xsl:if test="$customsOffice='391000'"><xsl:text>Urzad Celny w Poznaniu</xsl:text></xsl:if><xsl:if test="$customsOffice='443000'"><xsl:text>Urzad Celny III "Port Lotniczy" w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='372000'"><xsl:text>Urzad Celny w Elblagu</xsl:text></xsl:if><xsl:if test="$customsOffice='410000'"><xsl:text>Izba Celna w Rzepinie</xsl:text></xsl:if><xsl:if test="$customsOffice='350000'"><xsl:text>Izba Celna w Krakowie</xsl:text></xsl:if><xsl:if test="$customsOffice='411000'"><xsl:text>Urzad Celny w Zielonej G�rze</xsl:text></xsl:if><xsl:if test="$customsOffice='335000'"><xsl:text>Urzad Celny w Bielsku-Bialej</xsl:text></xsl:if><xsl:if test="$customsOffice='351000'"><xsl:text>Urzad Celny w Krakowie</xsl:text></xsl:if><xsl:if test="$customsOffice='361000'"><xsl:text>Urzad Celny I w Lodzi</xsl:text></xsl:if><xsl:if test="$customsOffice='333000'"><xsl:text>Urzad Celny w Czestochowie</xsl:text></xsl:if><xsl:if test="$customsOffice='360000'"><xsl:text>Izba Celna w Lodzi</xsl:text></xsl:if><xsl:if test="$customsOffice='330000'"><xsl:text>Izba Celna w Katowicach</xsl:text></xsl:if><xsl:if test="$customsOffice='421000'"><xsl:text>Urzad Celny w Szczecinie</xsl:text></xsl:if><xsl:if test="$customsOffice='312000'"><xsl:text>Urzad Celny w Lomzy</xsl:text></xsl:if><xsl:if test="$customsOffice='401000'"><xsl:text>Urzad Celny w Przemyslu</xsl:text></xsl:if><xsl:if test="$customsOffice='353000'"><xsl:text>Urzad Celny w Nowym Saczu</xsl:text></xsl:if><xsl:if test="$customsOffice='402000'"><xsl:text>Urzad Celny w Rzeszowie</xsl:text></xsl:if><xsl:if test="$customsOffice='445000'"><xsl:text>Urzad Celny w Pruszkowie</xsl:text></xsl:if><xsl:if test="$customsOffice='440000'"><xsl:text>Izba Celna w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='352000'"><xsl:text>Urzad Celny w Nowym Targu</xsl:text></xsl:if><xsl:if test="$customsOffice='422000'"><xsl:text>Urzad Celny w Koszalinie</xsl:text></xsl:if><xsl:if test="$customsOffice='363000'"><xsl:text>Urzad Celny w Piotrkowie Trybunalskim</xsl:text></xsl:if><xsl:if test="$customsOffice='412000'"><xsl:text>Urzad Celny w Gorzowie Wielkopolskim</xsl:text></xsl:if><xsl:if test="$customsOffice='430000'"><xsl:text>Izba Celna w Toruniu</xsl:text></xsl:if><xsl:if test="$customsOffice='442000'"><xsl:text>Urzad Celny II w Warszawie</xsl:text></xsl:if><xsl:if test="$customsOffice='381000'"><xsl:text>Urzad Celny w Opolu</xsl:text></xsl:if><xsl:if test="$customsOffice='302000'"><xsl:text>Urzad Celny w Lublinie</xsl:text></xsl:if><xsl:if test="$customsOffice='303000'"><xsl:text>Urzad Celny w Zamosciu</xsl:text></xsl:if><xsl:if test="$customsOffice='450000'"><xsl:text>Izba Celna we Wroclawiu</xsl:text></xsl:if></div></td></tr></table></xsl:template><!-- SZABLON DOT. DANYCH O MONOPOLU --><xsl:template match="*" mode="Monopol"><xsl:if test="ns5:* | ns6:* | ns7:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">C. DANE O REALIZACJI MONOPOLU PANSTWA</span><br/>Wypelniaja wylacznie podmioty prowadzace dzialalnosc w zakresie loterii pienieznych, gry telebingo, wideoloterii.</td></tr><tr><td bgcolor="#CCCCCC" width="42"/><td align="left" valign="top" width="548"><b>12. Dane o utworzeniu jednoosobowej spolki Skarbu Panstwa - art.4 ust.1 i 2 ustawy</b><p><xsl:value-of select="..//@data"/></p></td><td align="left" valign="top" width="343"><b>13. Data utworzenia (dzien-miesiac-rok)</b><br/><br/><div align="center" class="cz18" valign="bottom"><xsl:value-of select="substring(..//@creationDate,1,10)"/></div></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBLICZENIA PODATKU OD GIER --><xsl:template match="*" mode="ObliczeniePodatkuGry"><xsl:if test="ns5:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="5"><span class="nag1">D. OBLICZENIE PODATKU OD GIER</span></td></tr><tr align="center" bgcolor="#CCCCCC" valign="middle"><td width="324"><span class="cz14"><b>Rodzaje gier,<br/>zakladow wzajemnych,<br/>gier na automatach</b></span></td><td width="184"><span class="cz14"><b>Podstawa<br/>opodatkowania</b></span></td><td width="184"><span class="cz14"><b>Stawka podatkowa [%]</b></span></td><td width="185"><span class="cz14"><b>Kwota podatku</b></span></td></tr><xsl:for-each select=".//ns5:CalculationOfTaxOnGame"><tr><td><div align="right" class="cz14" valign="top"><xsl:value-of select="@typeOfGame"/></div></td><td><div align="right" class="cz14" valign="top"><xsl:value-of select="@tax"/></div></td><td><div align="right" class="cz14" valign="top"><xsl:value-of select="@taxRatePercentage"/></div></td><td><div align="right" class="cz14" valign="top"><xsl:value-of select="@amountOfTax"/></div></td></tr></xsl:for-each><tr><td bgcolor="#CCCCCC" colspan="3"><b>Razem</b><br/>Suma kwot z wierszy od D.5 do D.12. Kwote te nalezy przeniesc do poz.26 deklaracji POG-5.</td><td bordercolor="#000000"><b>42.</b><br/><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@totalOfTax"/></div></td></tr></table><table width="955"><tr><td><sup>1)</sup>Nalezy podac kolejny numer zalacznika.<br/></td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1"><xsl:apply-templates mode="stopka" select="."/></span><sub style="cz9">(1)</sub><b style="nag1">/1</b></td></tr></table></xsl:if><xsl:if test="ns7:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="5"><span class="nag1">C. OBLICZENIE PODATKU OD GIER</span></td></tr><tr align="center" bgcolor="#CCCCCC" valign="middle"><td width="184"><span class="cz14"><b>Podstawa<br/>opodatkowania</b></span></td><td width="184"><span class="cz14"><b>Stawka podatkowa [%]</b></span></td><td width="185"><span class="cz14"><b>Kwota podatku</b></span></td></tr><xsl:for-each select=".//ns7:CalculationOfTaxOnGame"><tr><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@tax"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@taxRatePercentage"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@amountOfTax"/></div></td></tr></xsl:for-each><tr><td bgcolor="#CCCCCC" colspan="2"><b>Razem</b><br/>Suma kwot z poz.15 i 18. <br/>Kwote z poz. 19 nalezy przeniesc do poz.28 deklaracji POG-5.</td><td bordercolor="#000000"><b>19.</b><br/><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@totalOfTax"/></div></td></tr></table><table width="955"><tr><td><sup>1)</sup>Nalezy podac kolejny numer zalacznika.</td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1"><xsl:apply-templates mode="stopka" select="."/></span><sub style="cz9">(1)</sub><b style="nag1">/1</b></td></tr></table></xsl:if><xsl:if test="ns6:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="5"><span class="nag1">C. OBLICZENIE PODATKU OD GIER</span></td></tr><tr align="center" bgcolor="#CCCCCC" valign="middle"><td width="184"><span class="cz14"><b>Podstawa<br/>opodatkowania</b></span></td><td width="184"><span class="cz14"><b>Stawka podatkowa [%]</b></span></td><td width="185"><span class="cz14"><b>Kwota podatku</b></span></td></tr><xsl:for-each select=".//ns6:Header"><tr><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@tax"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@taxRatePercentage"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@totalAmountOfTax"/></div></td></tr></xsl:for-each><tr><td bgcolor="#CCCCCC" colspan="2"><b>Razem</b><br/>Suma kwot.<br/>Kwote nalezy przeniesc do poz.27 deklaracji POG-5.</td><td bordercolor="#000000"><b>13.</b><br/><div align="right" class="cz18" valign="top"><xsl:value-of select=".//@totalAmountOfTax"/></div><div align="right" class="cz9" valign="bottom">zl</div></td></tr></table></xsl:if></xsl:template><!-- KONIEC all AG--></xsl:stylesheet>